package com.hero.objects.modifiers;

import org.jdom.Element;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.NakedModifier;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class DamageOverTime extends Modifier {

    private static String xmlID = "DAMAGEOVERTIME";

    public DamageOverTime(Element root) {
        super(root, DamageOverTime.xmlID);
    }

    @Override
    public String included(GenericObject o) {
        String ret = super.included(o);
        if (ret.trim().length() > 0) {
            return ret;
        }

        if (forceAllow()) return ret;
        if (o instanceof NakedModifier) {
            return "";
        }
        if (
        		(!o.getTypes().contains("ATTACK")
        			|| o.getTarget().equals("SELFONLY") 
        			|| o.getTarget().equals("N/A") 
        			|| !o.doesDamage())
                && !(o.getTypes().contains("MENTAL"))
                && !(o.getTypes().contains("ADJUSTMENT") && !(o.getTarget().equals("SELFONLY") 
                		|| o.getTarget().equals("N/A")))
            ) {
            return getDisplay()
                    + " can only be applied to Attack Powers and Powers which affect others.";
        }
        return "";
    }
    
    public String getColumn2Output() {
		String adderString = "";
		String ret = "";
		if (!showOptionOnly) {
			ret += getAlias();
		}
		double val = getTotalValue();
		if (!showOptionInParens && (getSelectedOption() != null)
				&& getSelectedOption().displayInString()
				&& (getSelectedOption().getAlias().trim().length() > 0)) {
			ret += " " + getSelectedOption().getAlias();
			ret = ret.trim();
		}
		if (!showInputInParens && (getInput() != null) && (getInput().trim().length() > 0)) {
			if (ret.trim().length() > 0) {
				ret += " ";
			}
			ret += getInput();
		}
		ret = ret.trim();
		for (Modifier mod : getAssignedModifiers()) {
			ret += ", " + mod.getAlias();
		}
		int index = 0;
		int parenCount = 0;
		while (ret.indexOf("(", index) >= 0) {
			parenCount++;
			index = ret.indexOf("(", index) + 1;
		}
		index = 0;
		while (ret.indexOf(")", index) >= 0) {
			parenCount--;
			index = ret.indexOf(")", index) + 1;
		}
		if (parenCount <= 0) {
			ret += " (";
		} else {
			ret += "; ";
		}
		if (showOptionInParens && (getSelectedOption() != null)
				&& getSelectedOption().displayInString()
				&& (getSelectedOption().getAlias().trim().length() > 0)) {
			ret += getSelectedOption().getAlias().trim() + "; ";
		}
		for (Adder ad : getAssignedAdders()) {
			if (ad.getXMLID().equals("INCREMENTS")) {
				ret += ad.getSelectedOption().getAlias()+" damage increments, ";
			}
		}
		for (Adder ad : getAssignedAdders()) {
			if (ad.getXMLID().equals("TIMEBETWEEN")) {
				ret += "damage occurs every "+ad.getSelectedOption().getAlias()+", ";
			} 
		}
		for (Adder ad : getAssignedAdders()) {
			if (!ad.isSelected()) {
				continue;
			}
			if (ad.getXMLID().equals("INCREMENTS")) {
				
			} else if (ad.getXMLID().equals("TIMEBETWEEN")) {
				
			} else if (ad.getColumn2Output().trim().length() > 0) {
				ret += ad.getColumn2Output().trim() + ", ";
			}
		}
		if (showInputInParens && (getInput() != null) && (getInput().trim().length() > 0)) {
			ret += getInputLabel()+" "+getInput()+"; ";
		}
		if (getComments().trim().length() > 0) {
			ret += getComments() + "; ";
		}
		if ((val > maxCost) && maxSet) {
			val = maxCost;
		}
		if ((val < minimumCost) && minSet) {
			val = minimumCost;
		}
		ret += getFraction(val) + ")";
		parenCount--;
		while (parenCount > 0) {
			ret += ")";
			parenCount--;
		}
		if (adderString.trim().length() > 0) {
			if (ret.trim().length() > 0) {
				ret += ", ";
			}
			ret += adderString;
		}
		return ret;
	}
    
    public double getTotalValue() {
		double val = getBaseCost();
		double incrementValue = 0d;
		double timeValue = 0d;
		for (Adder ad : getAssignedAdders()) {
			if (ad.getXMLID().equals("INCREMENTS")) {
				incrementValue = ad.getDoubleTotal();
			} else if (ad.getXMLID().equals("TIMEBETWEEN")) {
				timeValue = ad.getDoubleTotal();
			} else {
				val += ad.getDoubleTotal();
			}
		}
		if (getLevelValue() > 0) {
			val += getLevels() / getLevelValue() * getLevelCost();
		}
		double advantageTotal = 0d;
		for (Modifier mod : getAssignedModifiers()) {
			if (mod.getXMLID().equals("ONEDEFENSE")) {
				incrementValue *= 2;
			} else if (mod.getXMLID().equals("LOCKOUT")) {
				if (timeValue > 0) timeValue = 0;
				else timeValue *= 2;
			}
			else if (mod.getTotalValue() > 0) {
				advantageTotal += mod.getTotalValue();
			}
		}
		
		val = val + incrementValue + timeValue;
		
		double active = val * (1 + advantageTotal);
		double limitationTotal = 0d;
		for (Modifier mod : getAssignedModifiers()) {
			if (mod.getXMLID().equals("ONEDEFENSE")) {
				
			} else if (mod.getXMLID().equals("LOCKOUT")) {
				
			}
			else if (mod.getTotalValue() < 0) {
				limitationTotal += Math.abs(mod.getTotalValue());
			}
		}
		val = active / (1 + limitationTotal);

		// the following effectively "rounds" the value to the closest 1/4
		val = val * 4d;
		int mult = 1;
		if (val < 0) {
			mult = -1;
		}
		val = val * mult;
		val = Rounder.roundHalfUp(val);
		val = val * mult;
		val = val / 4d;

		if ((val < getMinimumCost()) && isMinSet()) {
			return getMinimumCost();
		} else if ((val > getMaxCost()) && isMaxSet()) {
			return getMaxCost();
		} else {
			return val;
		}
	}
}